# EE 367 Final Project Code - Siddhant Gupta

This is the code for the final project on **Mapping 3D Gaussian Splatting to a HW Architecture** done by Siddhant Gupta in the Winter 2025 offering of EE267. 

This work heavily adapts and relies upon the following two codebases:
1. https://github.com/graphdeco-inria/gaussian-splatting (Gaussian Splatting top level codebase provided by the original authors, using CUDA)
2. https://github.com/MrSecant/diff-gaussian-rasterization (Differentiable rasterization module from the original codebase, but adapted to use C/C++ instead of relying on a CUDA kernel)

The author of this course project is Siddhant Gupta, a MS student in Electrical Engineering and research assistant in the Stanford Accelerate lab. He can be reached at siddg@stanford.edu. 

# Submitted Code: forward.c

forward.c is the source file containing almost all of the code changes and contributions of this course project. With the permission of the course staff, only this file is included due to the size of the full codebase. This should be in the cpu_rasterizer subdirectory of the c_diff_rasterization codebase

This source file contains the source for the forward pass for gaussian splatting. The contributions compared to the original source includes code comments, time profiling code, and quantization. 

## Instructions to set up the codebase

1. Clone the top level repository (link #1 in the introduction of this page), recursively installing the submodules
2. Remove the differentiable rasterization module directory completely, and clone from link #2 into the submodules directory to replace the original CUDA rasterizer with the C/C++ implementation
3. Replace the forward.c file in the c-diff-rasterization file in this cloned codebase with the one provided here
4. Follow the instructions in the cloned c-diff rasterization codebase to install the required dependancies. You may need to create a local python environment (such as with Conda). If you are using ARM64 Mac architecture, you will need to add code to the setup python script to point the installation script to the necessary system libraries, like your compiler. You will likely need to use llvm on a ARM64 Mac rather than gcc for full compatibility. 
5. Replace any references to "CUDA" (in function names relating to the rasterizer for example) in the top level directory with "CPU" to point the codebase to the correct functions. 
6. Follow the instructions in the top level gaussian splatting library to run installation/compile the codebase. You will need to download the referenced models and datasets from the author's website, linked in the github page.
7. There are a few additional steps you may need to take to get a clean compilation. For example, the c-diff rasterization does not support antialiasing so you will need to remove references from that in the top level. In the configuration files for each model, you will need to add any missing fields that the compiler will inform you of (for example depths  '', since there is no depth map present but the codebase accepts one). You will also need to modify calls to the gaussian rasterizer function such that it is no longer expecting missing fields like the depths.
8. You can use the render.py (-s flag) script to render images with the pretrained model and the metrics.py to generate image quality metrics. Details of these calls is in the documentation for the top level repository. The timing information will be printed in the render script

## Changing the precision and rerunning
The function that is called, to specify the level of quantization, can be selected by changing the #define  PROCESS_PIXEL_MODE  0 at the top of the file to one of the ones in the associated comments. After making any changes to the c_diff code base, you must run the "pip install -e ." command in the c_diff directory before rerunning any of the python files in the top level gaussian splatting directory.
